window.addEventListener("load",function () {
  const load = this.document.querySelector(".load");
  load.classList.add("remove-load");
});

const navbar = document.getElementById("navbar");
const navbar2 = document.getElementById("navbar2");

window.addEventListener("scroll", function () {
  if (window.scrollY > 60) {
    navbar.style.opacity = 0;
  } else {
    navbar.style.opacity = 1;
    
  }

  if (window.scrollY > this.window.innerHeight) {
    navbar.classList.add("navbar-scroll");
    navbar.style.opacity = 1;
  } else {
    navbar.classList.remove("navbar-scroll");
  }
});


$(document).ready(function () {
  const persianDigits = {
    0: "۰",
    1: "۱",
    2: "۲",
    3: "۳",
    4: "۴",
    5: "۵",
    6: "۶",
    7: "۷",
    8: "۸",
    9: "۹",
  };

  function toPersianDigits(str) {
    return str.replace(/[0-9]/g, (d) => persianDigits[d]);
  }

  function traverse(el) {
    if (el.nodeType === 3) {
      el.data = toPersianDigits(el.data);
    }
    for (let i = 0; i < el.childNodes.length; i++) {
      traverse(el.childNodes[i]);
    }
  }

  traverse(document.body);

  $("input[placeholder], textarea[placeholder]").each(function () {
    const original = $(this).attr("placeholder");
    if (original) {
      $(this).attr("placeholder", toPersianDigits(original));
    }
  });
});

function convertPersian(str) {
  const persianDigits = {
    0: "۰",
    1: "۱",
    2: "۲",
    3: "۳",
    4: "۴",
    5: "۵",
    6: "۶",
    7: "۷",
    8: "۸",
    9: "۹",
  };

  return String(str).replace(/\d/g, (d) => persianDigits[d]);
}

const boxes = document.querySelectorAll('.box').forEach(box =>{
  const effect = Math.random() < 0.5 ? "fade-up" : "fade-bottom";
  box.setAttribute("data-aos-delay", "300");
  box.setAttribute('data-aos',effect)
});

AOS.init();

window.addEventListener('scroll', () => {
    const nowWidth = (window.scrollY / document.documentElement.scrollHeight) * 100;
    
    const nowEl = document.getElementById('now');

    if (nowWidth > 60) {
      nowEl.classList.add('w-100')
    }

    else {
      nowEl.classList.remove('w-100')
    }

    if (nowEl) {
        nowEl.style.width = `${nowWidth}%`;
    }
});